DROP FUNCTION IF EXISTS ab2_wkstplan__b_u() CASCADE;
CREATE OR REPLACE FUNCTION ab2_wkstplan__b_10_u__resource() RETURNS TRIGGER AS $$
    BEGIN

        -- Debug
        PERFORM LogDebugVerbose( message => format( 'a2w_id:%s;', old.a2w_id ) );
        -- a2w_resource_id_main_fix ist immer gesetzt, wenn etwas terminiert ist. Auch während einer Umterminierung (es wird kurz aus und wieder einterminiert) bleibt dies erhalten, während a2w_resource_id_main_terminated null ist.
        IF new.a2w_resource_id_main_fix IS DISTINCT FROM old.a2w_resource_id_main_fix THEN --
            new.a2w_resource_ks_abt_main_fix := (scheduling.resource__translate__resource_id__to__ksvba__shorthand(new.a2w_resource_id_main_fix)).ksb_ks_abt;

            -- bei kompletten Kostenstellenwechsel. Bei nur Arbeitsplatzwechsel bleibt der Status erhalten
            IF new.a2w_resource_ks_abt_main_fix IS DISTINCT FROM old.a2w_resource_ks_abt_main_fix THEN
                new.a2w_ncdone := FALSE;
                new.a2w_ncby := NULL;
            END IF;
        END IF;
        --
        IF new.a2w_resource_id_main_terminated IS DISTINCT FROM old.a2w_resource_id_main_terminated THEN
            new.a2w_resource_ks_abt_main_terminated := (scheduling.resource__translate__resource_id__to__ksvba__shorthand(new.a2w_resource_id_main_terminated)).ksb_ks_abt;
            new.a2w_oks := new.a2w_resource_ks_abt_main_terminated;

            SELECT ksb_ks_shorthand,
                   ksb_ks_ba_babz
              INTO new.a2w_ks,
                   new.a2w_ks_ba_babz
              FROM scheduling.resource__translate__resource_id__to__ksvba__shorthand(new.a2w_resource_id_main_terminated);
        END IF;
        --
        RETURN new;

    END $$ LANGUAGE plpgsql;

  /*
    ALTER TABLE ab2_wkstplan DISABLE TRIGGER ALL;

    UPDATE ab2_wkstplan
    SET
           a2w_oks = a2w_resource_ks_abt_main_terminated,
           a2w_ks  = (scheduling.resource__translate__resource_id__to__ksvba__shorthand(a2w_resource_id_main_terminated)).ksb_ks_shorthand
    FROM ab2 WHERE a2w_a2_id = a2_id AND a2_interm AND NOT a2_ende;

    ALTER TABLE ab2_wkstplan ENABLE TRIGGER ALL;


    SELECT a2_ab_ix, a2_n, a2_ks, a2_at, a2_et,
           a2w_oks, a2w_resource_ks_abt_main_terminated,
           a2w_ks, (scheduling.resource__translate__resource_id__to__ksvba__shorthand(a2w_resource_id_main_terminated)).ksb_ks_shorthand
    FROM  ab2_wkstplan, ab2 WHERE a2w_a2_id = a2_id AND a2_interm AND NOT a2_ende;
  */
--
  DROP TRIGGER IF EXISTS ab2_wkstplan__b_10_u__resource ON ab2_wkstplan;
  CREATE TRIGGER ab2_wkstplan__b_10_u__resource
      BEFORE UPDATE OF a2w_resource_id_main_fix, a2w_resource_id_main_terminated
      ON ab2_wkstplan
      FOR EACH ROW
      WHEN ( TSystem.execution_flag__isset__cascade_save( _flagname => 'inTerminierung' ) )   -- Nur während automatischer Terminierung. Verhinderung, dass "a2w_resource_ks_abt_main_terminated" bzw. "a2w_resource_ks_abt_main_fix" angepasst werden, wenn sich "a2w_resource_id_main_terminated" oder "a2w_resource_id_main_fix" ändert.
      EXECUTE PROCEDURE ab2_wkstplan__b_10_u__resource();
--
